/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRMusicRegion;
import lotr.common.world.feature.LOTRTreeType;
import lotr.common.world.feature.LOTRWorldGenBoulder;
import lotr.common.world.feature.LOTRWorldGenMirkOak;
import lotr.common.world.feature.LOTRWorldGenSkullPile;
import lotr.common.world.feature.LOTRWorldGenStalactites;
import lotr.common.world.map.LOTRFixedStructures;
import lotr.common.world.map.LOTRWaypoint;
import lotr.common.world.map.LOTRWorldGenUtumnoEntrance;
import lotr.common.world.spawning.LOTRBiomeSpawnList;
import lotr.common.world.spawning.LOTREventSpawner;
import lotr.common.world.spawning.LOTRSpawnList;
import lotr.common.world.structure.LOTRWorldGenMoredainMercCamp2;
import lotr.common.world.structure.LOTRWorldGenRAngbandBarrow;
import lotr.common.world.structure2.LOTRWorldGenAngbandFort;
import lotr.common.world.structure2.LOTRWorldGenAngbandTower;
import lotr.common.world.structure2.LOTRWorldGenBlackUrukFort2;
import lotr.common.world.structure2.LOTRWorldGenBlackUrukFort4;
import lotr.common.world.structure2.LOTRWorldGenRuinedHouse;
import lotr.common.world.structure2.LOTRWorldGenStoneRuin;
import lotr.common.world.structure2.LOTRWorldGenUtumnoWargPit;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenAngband
extends LOTRBiome {
    private LOTRWorldGenStalactites stalactiteIceGen = new LOTRWorldGenStalactites(LOTRMod.stalactiteIce);
    private WorldGenerator deadMoundGen = new LOTRWorldGenBoulder(LOTRMod.utumnoBrick, 2, 1, 3);
    public static final int WIGHT_FOG = 0;
    public static final int WIGHT_CLOUDS = 0;
    public static final int WIGHT_SKY = 0;

    public LOTRBiomeGenAngband(int i, boolean major) {
        super(i, major);
        this.func_76742_b();
        this.field_76752_A = Blocks.field_150433_aE;
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.spawnableLOTRAmbientList.clear();
        this.npcSpawnList.clear();
        this.biomeColors.setSky(10069160);
        LOTRBiomeSpawnList.SpawnListContainer[] arrspawnListContainer = new LOTRBiomeSpawnList.SpawnListContainer[]{LOTRBiomeSpawnList.entry(LOTRSpawnList.ANGBANDORC, 1).setSpawnChance(400), LOTRBiomeSpawnList.entry(LOTRSpawnList.ANGBANDWARG, 1).setSpawnChance(600), LOTRBiomeSpawnList.entry(LOTRSpawnList.ANGBANDWARGICE, 1).setSpawnChance(700), LOTRBiomeSpawnList.entry(LOTRSpawnList.ANGBAND3, 1).setSpawnChance(600)};
        this.npcSpawnList.newFactionList(100).add(arrspawnListContainer);
        this.decorator.addSoil((WorldGenerator)new WorldGenMinable(Blocks.field_150403_cj, 16), 40.0f, 32, 256);
        this.decorator.treesPerChunk = 0;
        this.decorator.flowersPerChunk = 0;
        this.decorator.grassPerChunk = 0;
        this.decorator.lichenPerChunk = 0;
        this.decorator.generateWater = false;
        this.decorator.addRandomStructure(new LOTRWorldGenRuinedHouse(false), 4000);
        this.decorator.addRandomStructure(new LOTRWorldGenStoneRuin.UTUMNO(1, 5), 300);
        this.decorator.addRandomStructure(new LOTRWorldGenBlackUrukFort2(false), 800);
        this.decorator.addRandomStructure(new LOTRWorldGenBlackUrukFort4(false), 800);
        this.decorator.addRandomStructure(new LOTRWorldGenAngbandTower(false), 800);
        this.decorator.addRandomStructure(new LOTRWorldGenUtumnoWargPit(false), 1000);
        this.decorator.addRandomStructure(new LOTRWorldGenRAngbandBarrow(false), 1000);
        this.decorator.addRandomStructure(new LOTRWorldGenMoredainMercCamp2(false), 800);
        this.setBanditChance(LOTREventSpawner.EventChance.NEVER);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterAngband;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.UTUMNO;
    }

    @Override
    public LOTRMusicRegion.Sub getBiomeMusic() {
        return LOTRMusicRegion.FORODWAITH.getSubregion("forodwaith");
    }

    @Override
    public boolean getEnableRiver() {
        return false;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        int i1;
        int l;
        super.func_76728_a(world, random, i, k);
        if (LOTRFixedStructures.UTUMNO_ENTRANCE.isAt(world, i, k)) {
            new LOTRWorldGenUtumnoEntrance().func_76484_a(world, random, i, world.func_72976_f(i, k), k);
        }
        for (l = 0; l < 2; ++l) {
            i1 = i + random.nextInt(16) + 8;
            int j1 = random.nextInt(60);
            int k1 = k + random.nextInt(16) + 8;
            this.stalactiteIceGen.func_76484_a(world, random, i1, j1, k1);
        }
        if (random.nextInt(20000) == 0) {
            LOTRWorldGenMirkOak tree = ((LOTRWorldGenMirkOak)LOTRTreeType.RED_OAK_WEIRWOOD.create(false, random)).disableRestrictions();
            i1 = i + random.nextInt(16) + 8;
            int k12 = k + random.nextInt(16) + 8;
            int j1 = world.func_72976_f(i1, k12);
            tree.func_76484_a(world, random, i1, j1, k12);
        }
        if (LOTRWorldGenAngbandFort.generatesAt(world, i, k)) {
            int x = i;
            int z = k;
            int y = world.func_72825_h(x, z);
            LOTRWorldGenAngbandFort genst = new LOTRWorldGenAngbandFort(false);
            genst.restrictions = false;
            genst.func_76484_a(world, random, x, y, z);
        }
        if (random.nextInt(32) == 0) {
            for (l = 0; l < 3; ++l) {
                int i11 = i + random.nextInt(16) + 8;
                int k11 = k + random.nextInt(16) + 8;
                int j11 = world.func_72976_f(i11, k11);
                this.deadMoundGen.func_76484_a(world, random, i11, j11, k11);
                new LOTRWorldGenSkullPile().func_76484_a(world, random, i11, j11, k11);
            }
        }
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.0f;
    }

    @Override
    public boolean canSpawnHostilesInDay() {
        return true;
    }
}

